package gov.va.med.mhv.admin.web.controller;

import gov.va.med.mhv.admin.dto.EmployeeDTO;
import gov.va.med.mhv.admin.dto.EmployeeOrgRoleDTO;
import gov.va.med.mhv.admin.dto.EmployeeOrgRoleHistoryDTO;
import gov.va.med.mhv.admin.dto.EmployeeSearchResult;
import gov.va.med.mhv.admin.service.vastaff.AdminUserService;
import gov.va.med.mhv.admin.service.vastaff.EmployeeRoleManagementService;
import gov.va.med.mhv.admin.service.vastaff.EmployeeSearchService;
import gov.va.med.mhv.admin.web.formbean.ManagedStaffMember;
import gov.va.med.mhv.admin.web.formbean.SearchResultsFormBean;
import gov.va.med.mhv.admin.web.util.SessionUtil;
import gov.va.med.mhv.admin.web.util.SpringContext;
import gov.va.med.mhv.common.api.exception.MHVException;

import java.util.List;

import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ManagedProperty;
import javax.faces.bean.RequestScoped;
import javax.faces.context.FacesContext;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeansException;

@ManagedBean(name="staffController")
@RequestScoped
public class ManageVAStaffController extends ManageVAStaffAbstractController {
	
	private static Logger log = LogManager.getLogger(ManageVAStaffController.class);

	
	@ManagedProperty(value="#{staffSearchResults}")
	SearchResultsFormBean searchResults;
	
	public String manageStaffMember(EmployeeOrgRoleDTO employeeOrg) {
		return this.manageStaffMember(employeeOrg.getEmployee().getUserName());
	}
	
	public String manageStaffMember(EmployeeSearchResult employeeResult) {
		return this.manageStaffMember(employeeResult.getUserName());
	}
		
	public String manageStaffMember(String userName) {
		if (userName == null) {
			userName = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("userName");
		}
		
		try {
			System.out.println("userName = " + userName);
			if (userName != null) {
				ManagedStaffMember staffMember = new ManagedStaffMember();
				
				// get employee from Active Directory (i.e. Existence Check)
				EmployeeSearchService employeeSearchService = (EmployeeSearchService) SpringContext.getApplicationContext().getBean("employeeSearchServiceProxy");
				// TODO:  Remove Hard Coded username
				List<EmployeeSearchResult> employeeSearchResults = employeeSearchService.searchByUserName("DNS   DavidA");
				if (employeeSearchResults == null || employeeSearchResults.size() == 0) {
					FacesContext.getCurrentInstance().addMessage("No search results.", new FacesMessage("User not found."));
				}
				else { // OK, the user exists and is permitted
					EmployeeSearchResult employee = employeeSearchResults.get(0);
					//get employee data from local database
					EmployeeRoleManagementService employeeRoleService = (EmployeeRoleManagementService) SpringContext.getApplicationContext().getBean("employeeRoleManagementServiceProxy");
					List<EmployeeSearchResult> employeeList = employeeRoleService.getEmployeeByUserName(userName);
					if (employeeList == null || employeeList.size() == 0) {
					}
					else if (employeeList.size() > 1) {
						FacesContext.getCurrentInstance().addMessage("More than 1 record returned.", new FacesMessage("Unexpected results from service."));
					}
					else {
						EmployeeSearchResult employeeToManage = employeeList.get(0);
						staffMember.setEmployeeToManage(employeeToManage);
					}

				}
				
				searchResults.setManaged(staffMember);
				// also load the role history
				getRoleHistory();
				// also load the comments (by loading the employee object which contains the comments)
				getEmployee(userName);
			}
		} catch (BeansException e) {
			FacesContext.getCurrentInstance().addMessage("Framework Error.", new FacesMessage("Unexpected error."));
			log.error("Error in employeeRoleManagementServiceProxy.getEmployeeOrgRolesAssignedToEmployeeByName() - Searching Proxy 'employeeRoleManagementServiceProxy'", e);
		} catch (MHVException e) {
			FacesContext.getCurrentInstance().addMessage("Application Error.", new FacesMessage("Unexpected error."));
			log.error("Error in employeeRoleManagementServiceProxy.getEmployeeOrgRolesAssignedToEmployeeByName() - Searching Proxy 'employeeRoleManagementServiceProxy'", e);
		}
		
		return "manage-staff-roles?faces-redirect=true";
	}

	public List<EmployeeOrgRoleHistoryDTO> getRoleHistory() {
		System.out.println("Getting Role History!");
		List<EmployeeOrgRoleHistoryDTO> roleHistoriesForEmployee = searchResults.getManaged().getRoleHistoriesForEmployee();
		if (roleHistoriesForEmployee == null) {
			System.out.println("fetching...");
			System.out.println(searchResults.getManaged().getEmployeeToManage().getId());
			try {
				Long employeeId = searchResults.getManaged().getEmployeeToManage().getId();
				EmployeeRoleManagementService employeeRoleService = (EmployeeRoleManagementService) SpringContext.getApplicationContext().getBean("employeeRoleManagementServiceProxy");
				roleHistoriesForEmployee = employeeRoleService.getRoleHistoriesForEmployee(employeeId);
				System.out.println("fetched!");
				searchResults.getManaged().setRoleHistoriesForEmployee(roleHistoriesForEmployee);
				System.out.println("Set!");
				System.out.println("Count: " + roleHistoriesForEmployee.size());
			} catch (Exception e) {
				System.out.println("Exception!!!!!!!!!");
				FacesContext.getCurrentInstance().addMessage("Application Error.", new FacesMessage("Unexpected error."));
				log.error("Error in employeeRoleManagementServiceProxy.getEmployeeOrgRolesAssignedToEmployeeByName() - Searching Proxy 'employeeRoleManagementServiceProxy'", e);
			}
		}
		return roleHistoriesForEmployee;
	}
	
	public SearchResultsFormBean getSearchResults() {
		return searchResults;
	}

	public void setSearchResults(SearchResultsFormBean searchResults) {
		this.searchResults = searchResults;
	}	
	
	/**
	 * This method looks up the EmployeeDTO object and remembers it for the user under management.  It places it in the
	 * searchResults bean that is session memory for all management for a single user.
	 * 
	 * @param userName
	 * @return
	 */
	public EmployeeDTO getEmployee(String userName) {
		EmployeeDTO employee = searchResults.getManaged().getManagedEmployee();
		try {
			AdminUserService adminUserService = (AdminUserService) SpringContext.getApplicationContext().getBean("adminUserServiceProxy");
			employee = adminUserService.findEmployeeByUserName(userName);
			searchResults.getManaged().setManagedEmployee(employee);
		} catch (BeansException e) {
			FacesContext.getCurrentInstance().addMessage("Application Error.", new FacesMessage("Unexpected error."));
			log.error("Error in adminUserService.getEmployee()", e);
			throw e;
		} catch (MHVException e) {
			FacesContext.getCurrentInstance().addMessage("Application Error.", new FacesMessage("Unexpected error."));
			log.error("Error in adminUserService.getEmployee()", e);
		}
		return employee;
	}
	
	public String activateRole(EmployeeOrgRoleDTO role) {
		
		System.out.println("Called activateRole(role)");
		
		try {
			role.setActive(Boolean.TRUE);
			EmployeeRoleManagementService service = (EmployeeRoleManagementService) SpringContext.getApplicationContext().getBean("employeeRoleManagementServiceProxy");
			service.updateEmployeeOrganizationRole(SessionUtil.getCurrentUser().getEmployeeId(), role);
		} catch (BeansException e) {
			FacesContext.getCurrentInstance().addMessage("Application Error.", new FacesMessage("Unexpected error."));
			log.error("Error in manageVAStaffController.activateRole", e);
		} catch (MHVException e) {
			FacesContext.getCurrentInstance().addMessage("Application Error.", new FacesMessage("Unexpected error."));
			log.error("Error in manageVAStaffController.activateRole", e);
		}
		
		return "";
	}
	
	public String deactivateRole(EmployeeOrgRoleDTO role) {
		
		System.out.println("Called deactivateRole(role)");
		
		try {
			role.setActive(Boolean.FALSE);
			EmployeeRoleManagementService service = (EmployeeRoleManagementService) SpringContext.getApplicationContext().getBean("employeeRoleManagementServiceProxy");
			service.updateEmployeeOrganizationRole(SessionUtil.getCurrentUser().getEmployeeId(), role);
		} catch (BeansException e) {
			FacesContext.getCurrentInstance().addMessage("Application Error.", new FacesMessage("Unexpected error."));
			log.error("Error in manageVAStaffController.activateRole", e);
		} catch (MHVException e) {
			FacesContext.getCurrentInstance().addMessage("Application Error.", new FacesMessage("Unexpected error."));
			log.error("Error in manageVAStaffController.activateRole", e);
		}
		
		return "";
	}
	
	public String saveComment() {
		String result = "";
		try {
			String comment = searchResults.getManaged().getManagedEmployee().getComments();
			System.out.println("Updated Comment: " + comment);

			AdminUserService adminUserService = (AdminUserService) SpringContext.getApplicationContext().getBean("adminUserServiceProxy");
			EmployeeDTO employeeDTO  = adminUserService.saveEmployee(searchResults.getManaged().getManagedEmployee());
			searchResults.getManaged().setManagedEmployee(employeeDTO); //update the attached Employee
			
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage("The employee has been successfully edited."));
		} catch (BeansException e) {
			FacesContext.getCurrentInstance().addMessage("Application Error.", new FacesMessage("Unexpected error."));
			log.error("Error in adminUserService.saveComment()", e);
		} catch (MHVException e) {
			FacesContext.getCurrentInstance().addMessage("Application Error.", new FacesMessage("Unexpected error."));
			log.error("Error in adminUserService.saveComment()", e);
		}
		
		return result;
	}
}
